#include<conio.h>
#include<math.h>
#include<GL/glut.h>
#include<stdlib.h>

#define white 1
#define black 2
#define MAXX 400.0
#define MAXY 400.0
#define MARGINX 40
#define MARGINY 40
#define FRICTION 0.02
#define startgame 0
#define menu 1
#define strikermove 2
#define direction 3
#define powerfunc 4
#define play 5
#define gameend 6
#define help 7
#define carrommargin 70*MAXX/500
#define true 1
#define false 0
#define notcovered 99

int player_win = false;

struct cord
{
       float x,y;                   //we will take coordinate with help of this stucture.
}vel[20],pos[20],cross;
int player= black,count=0;
float radius[20];
int event=menu;
int colour_black = 0, colour_white = 0, colour_queen = 0; 
int power = 110;

int score_white=0, score_black=0;
void initialize()                   //this function initialise and set the coins and striker.
{
    
     int i;
     for(i=0;i<20;i++)
     {
                     vel[i].x=0;vel[i].y=0;
                     radius[i]=15*MAXX/500;
     }
        pos[0].x = MARGINX+MAXX/2 - 2*radius[0];	    pos[0].y = MARGINY + MAXX/2 - 2*1.731*radius[0];
        pos[1].x = MARGINX+MAXX/2 + 2*radius[0];	    pos[1].y = MARGINY + MAXX/2 - 2*1.731*radius[0];
        pos[2].x = MARGINX+MAXX/2 - 1*radius[0];	    pos[2].y = MARGINY + MAXX/2 - 1*1.731*radius[0];
        pos[3].x = MARGINX+MAXX/2 - 4*radius[0];	    pos[3].y = MARGINY + MAXX/2 - 0*1.731*radius[0];
        pos[4].x = MARGINX+MAXX/2 + 2*radius[0];	    pos[4].y = MARGINY + MAXX/2 - 0*1.731*radius[0];
        pos[5].x = MARGINX+MAXX/2 + 4*radius[0];	    pos[5].y = MARGINY + MAXX/2 - 0*1.731*radius[0];
        pos[6].x = MARGINX+MAXX/2 - 1*radius[0];	    pos[6].y = MARGINY + MAXX/2 + 1*1.731*radius[0];
        pos[7].x = MARGINX+MAXX/2 - 2*radius[0];	    pos[7].y = MARGINY + MAXX/2 + 2*1.731*radius[0];
        pos[8].x = MARGINX+MAXX/2 + 2*radius[0];	    pos[8].y = MARGINY + MAXX/2 + 2*1.731*radius[0];
        
        pos[9].x = MARGINX+MAXX/2 - 0*radius[0];	    pos[9].y = MARGINY + MAXX/2 - 2*1.731*radius[0];
        pos[10].x = MARGINX+MAXX/2 - 3*radius[0];	pos[10].y = MARGINY + MAXX/2 - 1*1.731*radius[0];
        pos[11].x = MARGINX+MAXX/2 + 1*radius[0];	pos[11].y = MARGINY + MAXX/2 - 1*1.731*radius[0];
        pos[12].x = MARGINX+MAXX/2 + 3*radius[0];	pos[12].y = MARGINY + MAXX/2 - 1*1.731*radius[0];
        pos[13].x = MARGINX+MAXX/2 - 2*radius[0];  	pos[13].y = MARGINY + MAXX/2 - 0*1.731*radius[0];
        pos[14].x = MARGINX+MAXX/2 - 3*radius[0];	pos[14].y = MARGINY + MAXX/2 + 1*1.731*radius[0];
        pos[15].x = MARGINX+MAXX/2 + 1*radius[0];	pos[15].y = MARGINY + MAXX/2 + 1*1.731*radius[0];
        pos[16].x = MARGINX+MAXX/2 + 3*radius[0];	pos[16].y = MARGINY + MAXX/2 + 1*1.731*radius[0];
        pos[17].x = MARGINX+MAXX/2 ;	pos[17].y = MARGINY + MAXX/2+2*1.731*radius[0];
        
        pos[18].x = MARGINX+MAXX/2;	            pos[18].y = MARGINY + MAXX/2;
        pos[19].x = MARGINX+MAXX/2;             pos[19].y = MARGINY + carrommargin + 15*MAXX/500;
        
        radius[19]=18*MAXX/500;                             
        //we have define the initial position of centre of all coins.
}

void myinit(void)
{    // it creates the background
    glClearColor(0.0, 0.0, 0.3, 0.0); /* gray background */
    glShadeModel(GL_SMOOTH);
    glMatrixMode(GL_PROJECTION);      /* In World coordinates: */
    glLoadIdentity();                 /* position the "clipping rectangle" */
    gluOrtho2D(0,640,0,480);
    glMatrixMode(GL_MODELVIEW);       /* edge at -B/2 and its top edge at +B/2 */
}

void printstring(char *str,int m,int n)
{
    int ch=0;
    glRasterPos2f(m,n);
    while (str[ch]!='\0')
    {
         glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_24,str[ch]);

         ch++;
    }
}

void printcarrom(char *str,int m,int n)
{
     int ch=0;
     glRasterPos2f(m,n);
     while (str[ch]!='\0')
     {
          glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_24,str[ch]);
                 
          ch++; 
     }
}

void game_end(int pl)                               //this fuction ends the game,display the winning massege.
{              // a rectangle is created by this
               player_win = player;
               glColor3f( 1.0,0.5,0.5);
               glBegin(GL_POLYGON);
               glVertex2f( 100, 350);
               glVertex2f( 450, 350);
               glVertex2f(450, 250);
               glVertex2f(100, 250);
               glEnd();
               glColor3f( 0.0,0.3,0.5);
               // this prints the winning player name as the program ends
               char str[100]= " Player ";
               strcat( str, pl== white? "A" : "B");
               strcat( str," wins ");
               printstring(str,120,300);
               event = gameend;
               glutSwapBuffers();
}


void basedesign()                           //this fuction draw the board.
{
     int i,j; char str1[100], str2[100];
     glClear(GL_COLOR_BUFFER_BIT);
     glMatrixMode(GL_MODELVIEW);
     glLoadIdentity();
     
     //border
     glColor3f(0.0,0.0,0.0);
     glBegin(GL_POLYGON);
     glVertex2f(MARGINX-20,MARGINY-20);
     glVertex2f(MARGINX+MAXX+20,MARGINY-20);
     glVertex2f(MARGINX+MAXX+20,MARGINY+MAXY+20);
     glVertex2f(MARGINX-20,MARGINY+MAXY+20);
     glEnd();
     //board
     glColor3f(1.0,0.7,0.0);
     glBegin(GL_POLYGON);
     glVertex2f(MARGINX,MARGINY);
     glVertex2f(MARGINX+MAXX,MARGINY);
     glVertex2f(MARGINX+MAXX,MARGINY+MAXY);
     glVertex2f(MARGINX,MARGINY+MAXY);
     glEnd();
     
    
    //middle circle
     glBegin(GL_POLYGON);
     glColor3f(0.8,0.3,0.0);
        
               for(j=0;j<40;j++)
               {
                                glVertex3f((MARGINX +(MAXX/2))+((3.5*MAXX/32)+15)*cos(3.14*j/20),(MARGINY+(MAXY/2))+((3.5*MAXY/32)+15)*sin(3.14*j/20),0);
               }
               glEnd();
                  glBegin(GL_POLYGON);
     // smaller circle
     glColor3f(0.0,0.5,0.5);
        
               for(j=0;j<40;j++)
               {
                                glVertex3f((MARGINX +(MAXX/2))+((MAXX/32)+2)*cos(3.14*j/20),(MARGINY+(MAXY/2))+((MAXY/32)+2)*sin(3.14*j/20),0);
               }
               glEnd();
   
     //holes
     glBegin(GL_POLYGON);
     glColor3f(0.0,0.0,0.0);
        
               for(j=0;j<40;j++)
               {
                                glVertex3f((MARGINX +(MAXX*20/500))+(MAXX*20/500)*cos(3.14*j/20),(MARGINY+(MAXY*20/500))+(MAXY*20/500)*sin(3.14*j/20),0);
               }
               glEnd();
     
     glBegin(GL_POLYGON);
     glColor3f(0.0,0.0,0.0);
        
               for(j=0;j<40;j++)
               {
                                glVertex3f((MARGINX+MAXX-(MAXX*20/500))+((MAXX*20/500))*cos(3.14*j/20),(MARGINY+(MAXY*20/500))+(MAXY*20/500)*sin(3.14*j/20),0);
               }
               glEnd();
    
    glBegin(GL_POLYGON);
    glColor3f(0.0,0.0,0.0);
        
               for(j=0;j<40;j++)
               {
                                glVertex3f((MARGINX +(MAXX*20/500))+(MAXX*20/500)*cos(3.14*j/20),(MARGINY+MAXX-(MAXY*20/500))+(MAXY*20/500)*sin(3.14*j/20),0);
               }
               glEnd();
    
    glBegin(GL_POLYGON);
    glColor3f(0.0,0.0,0.0);
        
               for(j=0;j<40;j++)
               {
                                glVertex3f((MARGINX+MAXX-(40*MAXX/500)+17) +(20*MAXX/500)*cos(3.14*j/20),(MARGINY+MAXY-(40*MAXY/500)+17)+(MAXY*20/500)*sin(3.14*j/20),0);
               }
               glEnd();
    // boxes
    glBegin(GL_LINE_LOOP);
    glColor3f(0.0,0.0,0.0);
    glLineWidth(3.0);
    glVertex2f(MARGINX+(105*MAXX/500),MARGINY+(70*MAXY/500));
    glVertex2f(MARGINX+(395*MAXX/500),MARGINY+(70*MAXY/500));
    glVertex2f(MARGINX+(395*MAXX/500),MARGINY+(100*MAXY/500));
    glVertex2f(MARGINX+(105*MAXX/500),MARGINY+(100*MAXY/500));
    glEnd();
    
    glBegin(GL_LINE_LOOP);
    glVertex2f(MARGINX+(70*MAXX/500),MARGINY+(105*MAXY/500));
    glVertex2f(MARGINX+(70*MAXX/500),MARGINY+(395*MAXY/500));
    glVertex2f(MARGINX+(100*MAXX/500),MARGINY+(395*MAXY/500));
    glVertex2f(MARGINX+(100*MAXX/500),MARGINY+(105*MAXY/500));
    glEnd();
    
    
     glBegin(GL_LINE_LOOP);
     glVertex2f(MARGINX+(105*MAXX/500),MARGINY+MAXY-(70*MAXY/500));
     glVertex2f(MARGINX+(395*MAXX/500),MARGINY+MAXY-(70*MAXY/500));
     glVertex2f(MARGINX+(395*MAXX/500),MARGINY+MAXY-(100*MAXY/500));
     glVertex2f(MARGINX+(105*MAXX/500),MARGINY+MAXY-(100*MAXY/500));
        glEnd();
    
   
    glBegin(GL_LINE_LOOP);
    glVertex2f(MARGINX+MAXX-(70*MAXX/500),MARGINY+(105*MAXY/500));
    glVertex2f(MARGINX+MAXX-(70*MAXX/500),MARGINY+(395*MAXY/500));
    glVertex2f(MARGINX+MAXX-(100*MAXX/500),MARGINY+(395*MAXY/500));
    glVertex2f(MARGINX+MAXX-(100*MAXX/500),MARGINY+(105*MAXY/500));

         glEnd();
     
     //circles
    glBegin(GL_POLYGON);
    glColor3f(0.8,0.3,0.0);
        
               for(j=0;j<40;j++)
               {
                                glVertex3f(MARGINX+(13*MAXX/48)-20+((MAXX*15/500))*cos(3.14*j/20),MARGINY+(3*MAXY/16)-23+MAXX/24+(MAXY*15/500)*sin(3.14*j/20),0);
               }
               glEnd();
               
    glBegin(GL_POLYGON);
           
               for(j=0;j<40;j++)
               {
                                glVertex3f(MARGINX+(35*MAXX/48)+22+((MAXX*15/500))*cos(3.14*j/20),MARGINY+(3*MAXY/16)-23+MAXX/24+(MAXY*15/500)*sin(3.14*j/20),0);
               }
               glEnd();
               
    glBegin(GL_POLYGON);
   
        
               for(j=0;j<40;j++)
               {
                                glVertex3f(MARGINX+(3*MAXX/16)-23+MAXX/24+((MAXX*15/500))*cos(3.14*j/20),MARGINY+(13*MAXY/48)-22+(MAXY*15/500)*sin(3.14*j/20),0);
               }
               glEnd();
               
    glBegin(GL_POLYGON);
   
        
               for(j=0;j<40;j++)
               {
                                glVertex3f(MARGINX+(13*MAXX/48)-24-MAXX/24+((MAXX*15/500))*cos(3.14*j/20),MARGINY+(35*MAXY/48)+22+(MAXY*15/500)*sin(3.14*j/20),0);
               }
               glEnd();
               
    glBegin(GL_POLYGON);
    
        
               for(j=0;j<40;j++)
               {
                                glVertex3f(MARGINX+(13*MAXX/48)-23+((MAXX*15/500))*cos(3.14*j/20),MARGINY+(35*MAXY/48)+24+MAXY/24+(MAXY*15/500)*sin(3.14*j/20),0);
               }
               glEnd();
               
   glBegin(GL_POLYGON);
       
               for(j=0;j<40;j++)
               {
                                glVertex3f(MARGINX+(35*MAXX/48)+22+((MAXX*15/500))*cos(3.14*j/20),MARGINY+(35*MAXY/48)+24+MAXY/24+(MAXY*15/500)*sin(3.14*j/20),0);
               }
               glEnd();
               
   glBegin(GL_POLYGON);
    
        
               for(j=0;j<40;j++)
               {
                                glVertex3f(MARGINX+(35*MAXX/48)+24+MAXX/24+((MAXX*15/500))*cos(3.14*j/20),MARGINY+(13*MAXY/48)-22+(MAXY*15/500)*sin(3.14*j/20),0);
               }
               glEnd();
               
   glBegin(GL_POLYGON);
    
        
               for(j=0;j<40;j++)
               {
                                glVertex3f(MARGINX+(35*MAXX/48)+24+MAXX/24+((MAXX*15/500))*cos(3.14*j/20),MARGINY+(35*MAXY/48)+22+(MAXY*15/500)*sin(3.14*j/20),0);
               }
               glEnd();
    
     
     //lines
     glLineWidth(2.0);
     glBegin(GL_LINE_LOOP);
     glColor3f(0.0,0.0,0.0);
     glVertex2f(MARGINX+(13*MAXX/48)-20,MARGINY+(13*MAXY/48)-21);
     glVertex2f(MARGINX+(13*MAXX/48)-3+38,MARGINY+(13*MAXY/48)-4+38);
     glEnd();
     
      glLineWidth(2.0);
     glBegin(GL_LINE_LOOP);
     glColor3f(0.0,0.0,0.0);
     glVertex2f(MARGINX+(35*MAXY/48)+19,MARGINY+(13*MAXY/48)-21);
     glVertex2f(MARGINX+(35*MAXX/48)+13-48,MARGINY+(13*MAXY/48)-4+38);   
     glEnd();
     
      glLineWidth(2.0);
     glBegin(GL_LINE_LOOP);
     glColor3f(0.0,0.0,0.0);
     glVertex2f(MARGINX+(13*MAXX/48)-20,MARGINY+(35*MAXY/48)+19);
     glVertex2f(MARGINX+(13*MAXX/48)-14+48,MARGINY+(35*MAXY/48)+13-48);
     glEnd();
   
      glLineWidth(2.0);
     glBegin(GL_LINE_LOOP);
     glColor3f(0.0,0.0,0.0);
     glVertex2f(MARGINX+(35*MAXX/48)+19,MARGINY+(35*MAXY/48)+20);
     glVertex2f(MARGINX+(35*MAXX/48)+12-47,MARGINY+(35*MAXY/48)+15-49);
     glEnd();
     
     
     //arrows
     glBegin(GL_POLYGON);
     glColor3f(0.0,0.0,0.0);
     glVertex2f(MARGINX+(13*MAXX/48)-3+38,MARGINY+(13*MAXY/48)-4+38);
     glVertex2f(MARGINX+(13*MAXX/48)-3+38-10,MARGINY+(13*MAXY/48)-4+38);
     glVertex2f(MARGINX+(13*MAXX/48)-3+38,MARGINY+(13*MAXY/48)-4+38-10);
     glEnd();
        
     glBegin(GL_POLYGON);
     glColor3f(0.0,0.0,0.0);
     glVertex2f(MARGINX+(35*MAXX/48)+13-48,MARGINY+(13*MAXY/48)-4+38-10);
     glVertex2f(MARGINX+(35*MAXX/48)+13-48,MARGINY+(13*MAXY/48)-4+38);
     glVertex2f(MARGINX+(35*MAXX/48)+13-48+10,MARGINY+(13*MAXY/48)-4+38);
     glEnd();
     
     glBegin(GL_POLYGON);
     glColor3f(0.0,0.0,0.0);
     glVertex2f(MARGINX+(13*MAXX/48)-14+48-10,MARGINY+(35*MAXY/48)+13-48);
     glVertex2f(MARGINX+(13*MAXX/48)-14+48,MARGINY+(35*MAXY/48)+13-48);
     glVertex2f(MARGINX+(13*MAXX/48)-14+48,MARGINY+(35*MAXY/48)+13-48+10);
     glEnd();
     
     glBegin(GL_POLYGON);
     glColor3f(0.0,0.0,0.0);
     glVertex2f(MARGINX+(35*MAXX/48)+12-47,MARGINY+(35*MAXY/48)+15-49+10);
     glVertex2f(MARGINX+(35*MAXX/48)+12-47,MARGINY+(35*MAXY/48)+15-49);
     glVertex2f(MARGINX+(35*MAXX/48)+12-47+10,MARGINY+(35*MAXY/48)+15-49);
     glEnd();
     
     //power bar
     glBegin(GL_POLYGON);
     glColor3f(1.0,0.0,0.0);
     glVertex2f(500,40);
     glVertex2f(550,40);
     glVertex2f(550,power+40);
     glVertex2f(500,power+40);
     glEnd(); 
     
     glBegin(GL_LINE_LOOP);
     glLineWidth(25.0);
     glColor3f(0.0,0.0,0.0);
     glVertex2f(500,40);
     glVertex2f(550,40);
     glVertex2f(550,260);
     glVertex2f(500,260);
     glEnd();

    
       //turn of player
      
     glColor3f(0.0,1.0,1.0);  
     printstring(player==white?"A":"B", MARGINX+(MAXX/2),MARGINY-20);
     printstring(player==white?"B":"A", MARGINX+(MAXX/2),MARGINY+MAXY); 

      //score keeping
     glBegin(GL_LINE_LOOP);
     glLineWidth(25.0);
     glColor3f(0.0,1.0,0.0);
     glVertex2f(465,300);
     glVertex2f(638,300);
     glVertex2f(638,470);
     glVertex2f(465,470);
     glEnd();
     
     glBegin(GL_LINE_LOOP);
     glLineWidth(25.0);
     glVertex2f(465,420);
     glVertex2f(638,420);
     glEnd();
     
     itoa(score_white,str1,10);
     itoa(score_black,str2,10);
     
     glColor3f(0.6,0.8,0.6); 
     printstring("SCORES",507,445);
     printcarrom("PLAYER A",466,380);
     printcarrom("PLAYER B",466,320);
     printcarrom(str1,610,380);
     printcarrom(str2,610,320);     
}

void draw_board()
{
     int i,j;
     glClear(GL_COLOR_BUFFER_BIT);
     glMatrixMode(GL_MODELVIEW);
     glLoadIdentity();
     
     if (event==menu)             //this is the function for drawing the screen of menu.
     {
              // TEXT 1ST SCREEN
          
    
    glBegin(GL_LINE_LOOP);
    glColor3f(0.0,0.0,1.0);
    glLineWidth(6.0);
    glVertex2f(620,460);
    glVertex2f(620,400);
    glVertex2f(520,400);
    glVertex2f(520,460);
    glEnd();
    
    glBegin(GL_LINE_LOOP);
    glVertex2f(130,460);
    glVertex2f(360,460);
    glVertex2f(360,400);
    glVertex2f(130,400);
    glEnd();
    
    glBegin(GL_LINE_LOOP);
    glVertex2f(110,320);
    glVertex2f(405,320);
    glVertex2f(405,260);
    glVertex2f(110,260);
    glEnd();
    
    glBegin(GL_LINE_LOOP);
    glVertex2f(110,190);
    glVertex2f(405,190);
    glVertex2f(405,130);
    glVertex2f(110,130);
    glEnd();
        
      
    glColor3f(1.0,0.0,0.0); 
    printcarrom("CARROM MANIA",150,420);
    printstring("PLAY     PRESS 'ENTER'",130,280);
    printstring("HELP     PRESS 'H'",150,150);
    printstring("Esc",555,420);
    glutSwapBuffers();
    return;
   }
     
    if(event==help)            //this is for writting the help text.
    {
         glColor3f(1.0,0.0,0.0);
         printstring("How To Play ?",20,400);
         glColor3f(0.3,1.0,0.0);
         glBegin(GL_LINE_LOOP);
         glVertex2f(20,390);
         glVertex2f(170,390);
         glEnd();
         glColor3f(1.0,0.3,0.0);
         printstring("This is a well known black and white two player game where",40,330);
         printstring("on pocketing a coin score gets increased by one.",40,310);
         printstring("If a stiker is pocketed then it is a FOWL.",40,280);
         printstring("In case of fowl the score would be deducted by 1",40,250);
         printstring("The board gets rotated by 180 deg as the player changes",40,220);
         
         printstring("On first enter the direction of striker would be set",40,160);
         printstring("Direction of movement of striker wd be governed by the cross",40,130);
         printstring("whose direction can be set by the arrow keys .",40,100);
         printstring("Third enter would set the power by up down arrow keys. ",40,70);
         printstring(" on fourth enter the striker movement starts",40,40);
         glutSwapBuffers();
         return;
    
    }
     
     basedesign();
     
     for(i=0;i<19;i++)
     {
               glBegin(GL_POLYGON);                          //this is to give the color of the coins.
               if(i<9)
                      glColor3f(0.8,0.8,0.8);
               else if(i<18)
                      glColor3f(0.2,0.2,0.2);
               else
                   glColor3f(1.0,0.0,0.0);
                      
               
               for(j=0;j<40;j++)
               {
                                glVertex3f(pos[i].x+radius[i]*cos(3.14*j/20),pos[i].y+radius[i]*sin(3.14*j/20),0);
               }
               glEnd();
     }
     glBegin(GL_POLYGON);                                                                                                                               
     if(player == white)                  //this is for coloring of striker/
     glColor3f(1.0,1.0,1.0);                                                                                                                          
     else
     glColor3f(1.0,0.0,1.0);
     for(j=0;j<40;j++)
     {
                      glVertex3f(pos[19].x+radius[19]*cos(3.14*j/20),pos[19].y+radius[19]*sin(3.14*j/20),0);
     }
     glEnd();
     
     if(event==direction || event==powerfunc)
     {
     glColor3f(0.0,0.0,0.0);
     glLineWidth(3);
     glBegin(GL_LINES);
     glVertex2f(cross.x+10,cross.y+10);
     glVertex2f(cross.x-10,cross.y-10);
     glVertex2f(cross.x+10,cross.y-10);
     glVertex2f(cross.x-10,cross.y+10);
     glEnd();
     }
     if(event == gameend)
             game_end(player_win);

     glutSwapBuffers();
}
void striker_set()                 //this is the function which sets the striker after foul.
{  
      pos[19].x = MARGINX+MAXX/2;             pos[19].y = MARGINY + carrommargin + 15*MAXY/500;
      int i;
      for(i=0;i<19;i++)
      {
                       while(sqrt(pow(pos[19].x-pos[i].x,2)+pow(pos[19].y-pos[i].y,2))< radius[19]+radius[i])
                       {
                                       pos[19].x+=1;
                                       draw_board();
                       }
      }                   
}     

void swapboard()                //this rotates the board by 180 degree when 1 chance is over.
{
     int i;
     for(i=0;i<19;i++)
     {
                      if(pos[i].x==0)continue;                                                                    
                      pos[i].x=MAXX+2*MARGINX-pos[i].x;
                      pos[i].y=MAXY+2*MARGINY-pos[i].y;
     }
}
void reset_queen()               //this resets the queen at centre if it is not coveres.
{
       
                    pos[18].x=MARGINX+MAXX/2;
                    pos[18].y=MARGINY+MAXY/2;
                    radius[18]=15*(MAXX/500);
                    colour_queen=false;
                    int i;
                    for(i=0;i<18;i++)
                    {
                                       while(sqrt(pow(pos[18].x-pos[i].x,2)+pow(pos[18].y-pos[i].y,2))< radius[18]+radius[i])
                                       {
                                                       pos[18].x+=1;
                                                       draw_board();
                                       }
                    }                             
}
               
void score()                  //             this calculates the score of both players.
{       score_white=score_black=0;
        int i;
        for(i=0;i<9;i++)
        {              if(pos[i].x==0)
                       score_white++;
        }
        for(i=9;i<18;i++)
        {             if(pos[i].x==0)
                      score_black++;
        }             
        if(colour_queen==false &&( score_white==9 || score_black==9))
        game_end(player==white?black: white);
        else
        {if(player==white && score_white==9)              //we have also defined game end with the help of this fuction.
        game_end(white);
        else if(player==black && score_black==9)
        game_end(black);
        if(player==black && score_white==9)
        game_end(white);
        else if(player==white && score_black==9)
        game_end(black);
        }
         if ( colour_queen==white)
         score_white+=5;
         if (colour_queen==black)
         score_black+=5; 
}

void player_change()         //this changes the player once the chance of 1 player is over.It takes in account all the rules nd regulation
{                   
                       score();
                       if(event==gameend) return;
                       printf("P: %d,%d,%d,%d\n",player,colour_white,colour_black,colour_queen);
                       if(player==white && (colour_white==true || colour_queen== notcovered )&& colour_black == false)
                       { 
                                   if(colour_queen==notcovered)
                                   {
                                       if(colour_white== true)
                                       {colour_queen=white;score_white+=5;}
                                       else
                                       count++;
                                       if(count==2)
                                        {count=0; reset_queen();
                                         player = player==white? black: white;
                                         swapboard();
                                         //score();
                                        }
                                   }
                                   colour_white = false;
                                   colour_black = false;
                                   event= strikermove;     
                                   striker_set();
                                   return;
                       } 
                       
                       // similar case with player B
                       if ( player==black &&( colour_black==true|| colour_queen==notcovered) && colour_white == false)
                       {
                            if(colour_queen==notcovered)
                            {
                               if(colour_black== true)
                               {colour_queen=black;score_black+=5;}
                               else
                               count++; 
                                if(count==2)
                                { count=0; reset_queen();
                                  player = player==white? black: white;
                                  swapboard();
                                  
                                }
                            }   
                               
                            colour_white = false;
                            colour_black = false;
                            event = strikermove;  
                            striker_set();
                            return; 
                       
                       }
                       // this changes the player
                       printf("Count:%d\n",count);
                       
                       player = player==white? black: white;
                       swapboard();
                       striker_set();
                       event= strikermove;   
                       colour_white = false;
                       colour_black = false;              
                              
} 

void foul()    //       this places a coin on the center  if a player has done foul. and degrades the score and changes player's turn"
{
     int i;
                    if(player==white)
                    {
                                     for(i=0;i<9;i++)
                                     {
                                         if(radius[i]==0)
                                         {
                                          pos[i].x=MARGINX+MAXX/2;
                                          pos[i].y=MARGINY+MAXY/2;
                                          radius[i]=15*MAXX/500;
                                            draw_board();
                                            int j; 
                                            for(j=0;j<19;j++)
                                            {
                                                             if(i!=j)
                                                     {while(sqrt(pow(pos[i].x-pos[j].x,2)+pow(pos[i].y-pos[j].y,2))< radius[i]+radius[j])
                                                     {
                                                       pos[i].x+=1;
                                                       draw_board();
                                                       //printf("%f\n",sqrt(pow(pos[19].x-pos[i].x,2)+pow(pos[19].y-pos[i].y,2)));
                                                     }
                                                     }
                                            }
                                          break;
                                          }
                                     }
                    }
                    else if(player==black)
                    {
                                    for(i=9;i<18;i++)
                                    {
                                                     if(radius[i]==0)
                                                    {pos[i].x=MARGINX+MAXX/2;
                                                    pos[i].y=MARGINY+MAXY/2;
                                                    radius[i]=15*MAXX/500;
                                                    draw_board();
                                                    int j; 
                                                    for(j=0;j<19;j++)
                                                    {if(i!=j)
                                                     {while(sqrt(pow(pos[i].x-pos[j].x,2)+pow(pos[i].y-pos[j].y,2))< radius[i]+radius[j])
                                                     {
                                                       pos[i].x+=1;
                                                       draw_board();
                                                       //printf("%f\n",sqrt(pow(pos[19].x-pos[i].x,2)+pow(pos[19].y-pos[i].y,2)));
                                                     }}
                                                    }
                                                    break;}
                                    }
                    }
}

void hole()        //  this makes the radius of the coin 0 and place it outside if a coin is gone in the hole.
{     int i; 
      for(i=0; i<20; i++)
      {if( sqrt(pow(MARGINX + 20*(MAXX/500) - pos[i].x,2) + pow( MARGINY + 20*MAXY/500 - pos[i].y,2))< 20*MAXX/500)
           {
          radius[i]=0;
          pos[i].x = pos[i].y=0; 
          vel[i].x = vel[i].y=0; 
          if(i<9)colour_white = true;
          else if(i<18) colour_black = true;
          }
      
      if( sqrt (pow(MARGINX + 20*MAXX/500- pos[i].x,2)+ pow( MARGINY + MAXY - 20*MAXY/500 - pos [i].y,2))<  20*MAXX/500)
      {
      radius[i]=0;
      pos[i].x = pos[i].y=0; 
      vel[i].x = vel[i].y=0;
      if(i<9)colour_white = true;
      else if(i<18)colour_black = true; 
      }
      
      if( sqrt ( pow( MARGINX +MAXX - 20*MAXX/500 - pos [i].x,2)+ pow ( MARGINY + MAXY - 20*MAXY/500 - pos[i].y,2))<  20*MAXX/500)
      {
      radius[i]=0;
      pos[i].x = pos[i].y=0; 
      vel[i].x = vel[i].y=0;
      if(i<9)colour_white = true;
      else if(i<18)colour_black = true; 
      }
      
      if (sqrt ( pow ( MARGINX + MAXX - 20*MAXX/500 - pos[i].x,2)+ pow ( MARGINY + 20*MAXY/500 - pos [i].y,2))< 20*MAXX/500)
      {
                       radius[i]=0;
                       pos[i].x = pos[i].y=0; 
                       vel[i].x = vel[i].y=0;
                       if(i<9)colour_white = true;
                       else if(i<18)colour_black = true;
      }
       
       if(pos[19].x == 0)
       {
                    striker_set();
                    radius[19]=18*MAXX/500;
                    foul();
       }
       if(pos[18].x == 0 && colour_queen == false)
       colour_queen=notcovered;
      }
}         

void collision_update()        //this governs coin-coin collision, coin-board collision and update basescreen each and every time.
{
     int i,j; float temp,t1x,t2x,t1y,t2y,dist;
     int count = 0;
     
     for(i=0;i<20;i++)
     {
                     pos[i].x=pos[i].x+vel[i].x;
                     pos[i].y=pos[i].y+vel[i].y;
                     
                     if(sqrt(pow(vel[i].x,2)+pow(vel[i].y,2))<FRICTION/2)
                     {
                                                                         vel[i].x=0;vel[i].y=0;
                                                                         count++;
                                                                         continue;
                     }
                     vel[i].x-=vel[i].x*FRICTION/sqrt(pow(vel[i].x,2)+pow(vel[i].y,2));
                     vel[i].y-=vel[i].y*FRICTION/sqrt(pow(vel[i].x,2)+pow(vel[i].y,2));
                     
                     if(pos[i].x>=MARGINX+MAXX-radius[i])
                     {
                                                         vel[i].x=-vel[i].x;
                                                         pos[i].x=MARGINX+MAXX-radius[i];
                     }
     
                     if(pos[i].x<=MARGINX+radius[i])
                     {
                                                    vel[i].x=-vel[i].x;
                                                    pos[i].x=MARGINX+radius[i];
                     }
     
                     if(pos[i].y<=MARGINY+radius[i])
                     {
                                                    vel[i].y=-vel[i].y;
                                                    pos[i].y=MARGINY+radius[i];
                     }
     
                     if(pos[i].y>=MARGINY+MAXY-radius[i])
                     {
                                                         vel[i].y=-vel[i].y;
                                                         pos[i].y=MARGINY+MAXY-radius[i];
                     }
                     
                     for(j=0;j<20;j++)
                     {
                                       if(i==j)continue;
                                       dist=sqrt(pow(pos[i].x-pos[j].x,2)+pow(pos[i].y-pos[j].y,2));
                                       if(dist<radius[i]+radius[j])
                                       {
                                                                   pos[i].x+=0.5*(pos[i].x-pos[j].x)/dist;
                                                                   pos[i].y+=0.5*(pos[i].y-pos[j].y)/dist;
                                                                   pos[j].x-=(pos[i].x-pos[j].x)/dist;
                                                                   pos[j].y-=(pos[i].y-pos[j].y)/dist;
                                                                   
                                                                   t1x=(pos[i].x-pos[j].x)*vel[i].x+(pos[i].y-pos[j].y)*vel[i].y;
                                                                   t1y=(pos[i].x-pos[j].x)*vel[i].y-(pos[i].y-pos[j].y)*vel[i].x;
                                                                   t2x=(pos[i].x-pos[j].x)*vel[j].x+(pos[i].y-pos[j].y)*vel[j].y;
                                                                   t2y=(pos[i].x-pos[j].x)*vel[j].y-(pos[i].y-pos[j].y)*vel[j].x;
                                                                   
                                                                   vel[i].y=((pos[i].x-pos[j].x)*t1y+(pos[i].y-pos[j].y)*t2x)/(pow(radius[i]+radius[j],2));
                                                                   vel[i].x=((pos[i].x-pos[j].x)*t2x-(pos[i].y-pos[j].y)*t1y)/(pow(radius[i]+radius[j],2));
                                                                   vel[j].y=((pos[i].x-pos[j].x)*t2y+(pos[i].y-pos[j].y)*t1x)/(pow(radius[i]+radius[j],2));
                                                                   vel[j].x=((pos[i].x-pos[j].x)*t1x-(pos[i].y-pos[j].y)*t2y)/(pow(radius[i]+radius[j],2));
                                       }
                     }
     } 
     hole();
     if(count == 20)
     {
           glutIdleFunc(NULL); player_change();
     }           
     draw_board();
     sleep(10); 
}

void keypress(char ch, int x, int y)        //   this fuction takes the input from keyboard and we use this to work out other  functions.
{    
     int i,j;
       // we have defined the event to startgame and then we are changing event one by one to move to next event
     switch(event)
     {
     
                  case startgame: switch(ch)
                                  {  
                                       case 13: event=menu; printf("%d",event); break;
                                       case 27:exit(0);
                                  }break;                
                                  
                  case menu:      switch(ch)
                                  {
                                       case 'H':
                                       case 'h':event=help; printf("Help");break;
                                       case 13: event=strikermove; printf("%d",event); break;
                                       case 27:exit(0);break;
                                  }break;
                                  
                  case help:      switch(ch)
                                  {
                                            case 27: case 13:event=menu;break;
                                  }break;
                                  
                  case direction: switch(ch)
                                  {
                                            case 37:cross.x-=2;
                                    if(cross.x<MARGINX) cross.x=MARGINX;
                                            case 39:cross.x+=2;
                                    if(cross.x>MARGINX+MAXX) cross.x=MARGINX+MAXX;
                                            case 38:cross.y-=2;
                                    if(cross.y<MARGINY) cross.y=MARGINY;
                                            case 40:cross.y+=2;
                                    if(cross.y>MARGINY+MAXY) cross.y=MARGINY+MAXY;
                                            case 13:event=powerfunc; break;
                                            case 27:exit(0);break;   
                                  }break;
                  case powerfunc: switch(ch)
                                  {
                                    case 's':power-=5;
                                if(power<=0) power=0; printf("%d",power); break;
                                    case 'w':power+=5;
                                if(power>=220) power=220;  printf("%d",power); break;
                                    case 13:vel[19].x=power/20*(-pos[19].x+cross.x)/sqrt(pow(pos[19].x-cross.x,2)+pow(pos[19].y-cross.y,2));
                                            vel[19].y=power/20*(-pos[19].y+cross.y)/sqrt(pow(pos[19].x-cross.x,2)+pow(pos[19].y-cross.y,2));
                                            event=99; 
                                            glutIdleFunc(collision_update);break;
                                    case 27:exit(0);break;

                                }break;
                  case strikermove:switch(ch)
                                   {
                                   case 'a':pos[19].x-=2;
                                           if(pos[19].x<radius[19]+carrommargin+MARGINX+(MAXX/50)*3-5)
                                           pos[19].x=radius[19]+carrommargin+MARGINX+(MAXX/50)*3-5;
                                    
                                           for(i=0;i<19;i++)
                                           {
                                                    if(sqrt(pow(pos[19].x-pos[i].x,2)+pow(pos[19].y-pos[i].y,2))< radius[19]+radius[i])
                                                    {
                                                           if(pos[19].x-(2*(pos[19].x-pos[i].x))>=carrommargin + MARGINX+3*(MAXX/50)-5+radius[19])
                                                           pos[19].x-=2*(pos[19].x-pos[i].x);
                                                           else
                                                           pos[19].x+=2;
                                                    }
                                           }break;
                                    case 'd':pos[19].x+=2;
                                           if(pos[19].x>=MAXX+ MARGINX-carrommargin-3*(MAXX/50)+5-radius[19])
                                           pos[19].x=MAXX + MARGINX - carrommargin-3*(MAXX/50)+5-radius[19];
                                       
                                           for(i=0;i<19;i++)
                                           {
                                                    if(sqrt(pow(pos[19].x-pos[i].x,2)+pow(pos[19].y-pos[i].y,2))< radius[19]+radius[i])
                                                    {
                                                            if(pos[19].x+2*(pos[i].x-pos[19].x)<MAXX+MARGINX-carrommargin-3*MAXX/50+5-radius[19])
                                                            pos[19].x+=2*(pos[i].x-pos[19].x);
                                                            else
                                                            pos[19].x-=2;
                                                    }
                                           }break;      
                                    case 13: event=direction;
                                             cross.x=MARGINX+MAXX/2;
                                             cross.y=MARGINY+MAXY/2; break;
                                    case 27:exit(0); break;
                                }break;
                                
                 case gameend : switch(ch){
                                          case 13:event=menu;initialize();score();draw_board();break;
                                          case 27:exit (0);
                                          }
                 }
     draw_board();            
}
     

void key_spec(int ch, int x, int y)       //  this is also for input of values we have to use this because glutkeyboard did not take  arrowkeys as input.
{    
     int i,j;
       
     switch(event)
     {
                  case direction: switch(ch)
                                  {
                                            case 100:cross.x-=2;
                                    if(cross.x<MARGINX) cross.x=MARGINX;break;
                                            case 102:cross.x+=2;
                                    if(cross.x>MARGINX+MAXX) cross.x=MARGINX+MAXX;break;
                                            case 103:cross.y-=2;
                                    if(cross.y<MARGINY) cross.y=MARGINY;break;
                                            case 101:cross.y+=2;
                                    if(cross.y>MARGINY+MAXY) cross.y=MARGINY+MAXY;  break;
                                  }break;
                  case powerfunc: switch(ch)
                                  {
                                    case 103:power-=5;
                                if(power<=0) power=0; printf("%d",power); break;
                                    case 101:power+=5;
                                if(power>=220) power=220;  printf("%d",power); break;
                                }break;
                  case strikermove:switch(ch)
                                   {
                                   case 100:pos[19].x-=2;
                                           if(pos[19].x<radius[19]+carrommargin+MARGINX+3*MAXX/50-5)
                                           pos[19].x=radius[19]+carrommargin+MARGINX+3*MAXX/50-5;
                                    
                                           for(i=0;i<19;i++)
                                           {
                                                    if(sqrt(pow(pos[19].x-pos[i].x,2)+pow(pos[19].y-pos[i].y,2))< radius[19]+radius[i])
                                                    {
                                                           if(pos[19].x-(2*(pos[19].x-pos[i].x))>=carrommargin + MARGINX+3*MAXX/50-5+radius[19])
                                                           pos[19].x-=2*(pos[19].x-pos[i].x);
                                                           else
                                                           pos[19].x+=2;
                                                    }
                                           }break;
                                    case 102:pos[19].x+=2;
                                           if(pos[19].x>=MAXX+ MARGINX-carrommargin-3*MAXX/50+5-radius[19])
                                           pos[19].x=MAXX + MARGINX - carrommargin-3*MAXX/50+5-radius[19];
                                       
                                           for(i=0;i<19;i++)
                                           {
                                                    if(sqrt(pow(pos[19].x-pos[i].x,2)+pow(pos[19].y-pos[i].y,2))< radius[19]+radius[i])
                                                    {
                                                            if(pos[19].x+2*(pos[i].x-pos[19].x)<MAXX+MARGINX-carrommargin-3*MAXX/50+5-radius[19])
                                                            pos[19].x+=2*(pos[i].x-pos[19].x);
                                                            else
                                                            pos[19].x-=2;
                                                    }
                                           }break;
                                }
      }
     draw_board();            
}

void display()
{
  static float i=0;                                  
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);     /* clear the window */
 
  //glMatrixMode(GL_MODELVIEW);       /* The following coordinates are expressed */
  glLoadIdentity();                 /* in terms of World coordinates */
  glColor3f(1.0,1.0,1.0);
  glBegin(GL_POLYGON);
                     glVertex2f(100,100);
                     glVertex2f(200,100);
                     glVertex2f(200,200);
                     glVertex2f(100,200);
  glEnd();                   
  glutSwapBuffers();                     /* send all commands */
}       

int main(int argc,char **argv)
{
    glutInit(&argc,argv);
    glutInitWindowSize(640,480);
    glutInitWindowPosition(20,20);
    glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE);
    glutCreateWindow("Screen");
    myinit();
    initialize();
    player_change();
    event = menu;
    glutDisplayFunc(draw_board);
    glutKeyboardFunc(keypress);
    glutSpecialFunc(key_spec);
    glutIdleFunc(NULL);
    glutMainLoop();
}
